#ifndef __CDimension__
#define __CDimension__

#include "../Basics/CCountedObject.hpp"
using Exponent::Basics::CCountedObject;

//	===========================================================================

namespace Exponent
{
	namespace MathTools
	{
		/**
		 * @class CDimension CDimension.hpp
		 * @brief Representation of a dimension
		 *
		 * @date 03/03/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CDimension.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CDimension : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param width The width of the unit
			 * @param height The height of the unit
			 */
			CDimension(const long width = 0, const long height = 0);

			/**
			 * Copy construction
			 * @param dimension The dimension to copy
			 */
			CDimension(const CDimension &dimension);

			/**
			 * Destruction
			 */
			virtual ~CDimension();

//	===========================================================================

			/**
			 * Assignment operator
			 * @param dimension The dimension to copy
			 * @retval CDimension& A refeernce to this
			 */
			CDimension &operator = (const CDimension &dimension);

			/**
			 * Equality operator
			 * @param dimension The dimension to compare to
			 * @retval bool True if the dimensions are the same, false otherwise
			 */
			bool operator == (const CDimension &dimension);

//	===========================================================================

			/**
			 * Set the entire dimension
			 * @param width The width of the unit
			 * @param height The height of the unit
			 */
			void setDimension(const long width, const long height);

			/**
			 * Copy another dimension
			 * @param dimension The dimension to copy
			 */
			void setDimension(const CDimension &dimension);

			/**
			 * Set the width
			 * @param width The width of the unit
			 */
			void setWidth(const long width);

			/**
			 * Set the height
			 * @param height The height of the unit
			 */
			void setHeight(const long height);

//	===========================================================================

			/**
			 * Get the width
			 * @retval long The width 
			 */
			long getWidth() const;

			/**
			 * Get the height
			 * @retval long The height 
			 */
			long getHeight() const;

//	===========================================================================

		protected:

//	===========================================================================

			long m_width;				/**< Width */
			long m_height;				/**< Height */
		};
	}
}
#endif	// End of CDimension.hpp